IF EXISTS
(
    SELECT *
    FROM SYS.PROCEDURES
    WHERE NAME = 'P_CTB_CNT_DRE_PROCESSAMENTO_MOV_FILIAL'
)
    DROP PROCEDURE P_CTB_CNT_DRE_PROCESSAMENTO_MOV_FILIAL;
GO
CREATE PROCEDURE P_CTB_CNT_DRE_PROCESSAMENTO_MOV_FILIAL @MES INT,
														@ANO INT,
														@TP_DRE INT,
														@TP_RAT_CENTRO_CUSTO INT,
														@CD_USU INT
AS
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_CTR INT
DECLARE @CD_FILIAL_PROC VARCHAR(MAX)

DECLARE @DT_INI_PROC DATETIME
DECLARE @CD_CTR_ATUAL INT

DECLARE ProcDREFilial CURSOR FAST_FORWARD FOR
SELECT
	PRC_FILIAL.CD_EMP,
	PRC_FILIAL.CD_FILIAL	
FROM
	PRC_FILIAL
WHERE
	FLAG_ANALISE_DRE=1

SET @CD_FILIAL_PROC=''

OPEN ProcDREFilial;
FETCH NEXT FROM ProcDREFilial INTO @CD_EMP, @CD_FILIAL;

WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT '  Filial ' + CONVERT(VARCHAR(5), @CD_FILIAL) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';

		EXECUTE P_CTB_CNT_DRE_RESULTADO @CD_EMP, @CD_FILIAL,@ANO,@MES,@TP_DRE,@TP_RAT_CENTRO_CUSTO,@CD_USU,1;
		
		IF @CD_FILIAL_PROC=''
			BEGIN
				SET @CD_FILIAL_PROC = CONVERT(VARCHAR(4),@CD_FILIAL)
			END
		ELSE
			BEGIN
				SET @CD_FILIAL_PROC = @CD_FILIAL_PROC + ',' + CONVERT(VARCHAR(4),@CD_FILIAL)
			END

		FETCH NEXT FROM ProcDREFilial INTO @CD_EMP, @CD_FILIAL;
	END ;
PRINT '*******************************************************************************************************';
PRINT '  Centralizado ' + CONVERT(VARCHAR(5), @CD_FILIAL) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
EXECUTE P_CTB_CNT_DRE_RESULTADO @CD_EMP, @CD_FILIAL_PROC,@ANO,@MES,@TP_DRE,@TP_RAT_CENTRO_CUSTO,@CD_USU,1;

CLOSE ProcDREFilial ;
DEALLOCATE ProcDREFilial ;